/*
ͻ
 NAME      : MODEM.C                                                         
 FUNCTION  : Library to control the used (TeleTex OR HAYES) modem.           
 REMARKS   :  To activate this unit clock interrupt, you have to include the
           : following lines in the main routine:                            
           :         install_Clock();                                        
           : Do NOT forget to disactivate it before terminating the program: 
           :         un_install_Clock();                                     
           : This interrupt will up-date the "connected" variable at each    
           : second for an HAYES modem. It will also up-date the "C" signal  
           : into screen to inform the user that he is connected ("ShowCorF" 
           : has to be set TRUE for this...).                                
           : Please, note that "Check_HModem_State" can't be used to check   
           : the connect status of the Minitel: The connect status of it     
           : it must be interpreted by the VideoTex trancoding procedure...  
           :  As an assembler line can be noted in this listing, it is      
           : necessary to use the TCC assembler to compile it...             
 COPYRIGHT : HETRU Fabrice 1991-1995.                                        
ͼ
*/



#include <dos.h>
#include <string.h>

#define  byte    unsigned char

#define  Int1C   0x1C  /* BIOS interrupt number for the clock interrupt.     */
#define  FALSE   0     /* Logical value for "FALSE".                         */
#define  TRUE    1     /* Logical value for "TRUE".                          */

/* Modem type in use: MINITEL ou HAYES ? */
#define  TlTex     0
#define  Hayes     1
/* Command codes to send to the modem.   */
#define  Generique 0
#define  InitMod   1
#define  Connect   2
#define  Appel     3
#define  Raccroch  4
#define  ConnexFin 5

/* Variables usefull for the interfacing of this library. */
byte     ModemUsed = Hayes;       /* HAYES modem used by default.            */
byte     DTR_Cmde = TRUE;         /* DTR is used to specify modem commands.  */
byte     HAYESPrefix[4] = {'+','+','+',0}; /* Default HAYES command prefix.  */
byte     PulseDial = TRUE;        /* Pulses calls in use.                    */
byte     connected = FALSE;       /* System is supposed to be not connected. */
byte     Show_CorF = FALSE;       /* No connect status signal to write.      */
byte     ItClk_active = FALSE;    /* The clock interrupt is NOT in use yet...*/

/* Modems codes and specials controls commands,         */
/* which may possibly be adaptated...                   */
/* The 0 byte seted at the end of each code is COMPULSO-*/
/* -RY so that the codes may be managed using the C     */
/* string operators.                                    */
char     Esc[2] = {0x1B,0};
char     Sep[2] = {0x13,0};
char     Pro1[2] = {0x39,0};
char     Cod1[2] = {0x67,0};
char     Cod2[2] = {0x68,0};
char     Cod3[2] = {0x49,0};
char     HayesCod[3] = "AT";
char     PulsD[2] = {'P',0};
char     FreqD[2] = {'T',0};
char     HayesInit[17] = " Z0 &D1 X0 V2 B2";
char     HayesConnect[2] = "D";
char     HayesDeconnex[3] = "H0";
char     Lfeed[2] = {0x0D,0};

/* General internals variables. */
union    REGS inregs,outregs;
struct   SREGS segregs;
int      Curs_C = 0x7043;
int      Curs_F = 0x7046;
unsigned int seg_ecran;



#include "STARINTF.C"


void Beep(int Freq, int Tempo)
  {
  sound(Freq);
  delay(Tempo);
  nosound();
  }


void CmdeToModem(byte TypCmde, char *DataCmde)
  {
  char Chaine_CMDE[30];
  unsigned int Nb_transmited;
  byte Sended;

  Nb_transmited = 0;
  strcpy(Chaine_CMDE,"");
  switch (ModemUsed)
    {
    case TlTex:
      {
      strcpy(Chaine_CMDE,Esc);
      switch (TypCmde)
        {
        case Generique:
          { strcat(Chaine_CMDE,Pro1); strcat(Chaine_CMDE,Cod1); break; }
        case InitMod:
          { strcpy(Chaine_CMDE," "); break; }
        case Connect:
          { strcat(Chaine_CMDE,Pro1); strcat(Chaine_CMDE,Cod2); break; }
        case Appel:
          { strcpy(Chaine_CMDE," "); break; }
        case Raccroch:
          { strcat(Chaine_CMDE,Pro1); strcat(Chaine_CMDE,Cod1); break; }
        case ConnexFin:
          {
          if (connected)
            {
            strcat(Chaine_CMDE,Sep);
            strcat(Chaine_CMDE,Cod3);
            }
          else
            {
            strcat(Chaine_CMDE,Pro1);
            strcat(Chaine_CMDE,Cod2);
            }
          }
        }
      if (strlen(Chaine_CMDE)>0)
        {
        strcat(Chaine_CMDE,Lfeed);
        if (WriteSerie(Chaine_CMDE,strlen(Chaine_CMDE),&Nb_transmited)!=0)
          Beep(500,500);
        }
      break;
      }
    case Hayes:
      {
      if (TypCmde!=Generique) strcat(Chaine_CMDE,HayesCod);
      switch (TypCmde)
        {
        case Generique: { strcat(Chaine_CMDE,DataCmde); break; }
        case InitMod:
          {
          strcat(Chaine_CMDE,HayesInit);
          break;
          }
        case Connect:
          {
          strcat(Chaine_CMDE,HayesConnect);
          break;
          }
        case Appel:
          {
          if (connected | (DataCmde==" "))
            strcpy(Chaine_CMDE," ");
          else
            {
            strcat(Chaine_CMDE,HayesConnect);
            if (PulseDial) strcat(Chaine_CMDE,PulsD);
              else strcat(Chaine_CMDE,FreqD);
            strcat(Chaine_CMDE,DataCmde);
            }
          break;
          }
        case Raccroch: { strcat(Chaine_CMDE,HayesDeconnex); break; }
        case ConnexFin: if (connected) strcat(Chaine_CMDE,HayesDeconnex);
                     else strcat(Chaine_CMDE,HayesConnect);
        }
      if (strlen(Chaine_CMDE)>0)
        {
        if (!DTR_Cmde)
          {
          if (connected)
            {
            delay(1000);
            Sended = WriteCmde(HAYESPrefix,strlen(HAYESPrefix),DTR_Cmde);
            if (Sended==0) delay(1000);
            }
          else Sended = 0;
          }
        else Sended = 0;
        if (Sended==0)
          {
          strcat(Chaine_CMDE,Lfeed);
          if (WriteCmde(Chaine_CMDE,strlen(Chaine_CMDE),DTR_Cmde)!=0)
            Beep(500,500);
          if (connected)
            {
            delay(1200);
            strcpy(Chaine_CMDE,"ATO");
            strcat(Chaine_CMDE,Lfeed);
            Sended = WriteCmde(Chaine_CMDE,strlen(Chaine_CMDE),FALSE);
            }
          }
        }
      }
    }
  }


static void interrupt (*OldIClk) ();


void interrupt Check_HModem_State()
  {
  static byte compteur = 0;
  char mod_scr;

  /* Up-date at each second... */
  compteur++;
  if ( (compteur>=0x12) & (!ItClk_active) )
    {
    /* No multiple entrance in this area ! */
    ItClk_active = TRUE;

    /* 8259 and CPU acquittance to allow the serial receipts... */
    outportb(0x20,0x20);
    enable();

    /* Checking the connect status. */
    Modem_Status();
    connected=Porteuse;

    /* Writting the "C" or "F" alert into screen. */
    if (Show_CorF)
      {
      mod_scr = peekb(0x40,0x49);
      if (connected)
        {
        if ( (mod_scr==2) | (mod_scr==3) | (mod_scr==7) )
          poke(seg_ecran,158,Curs_C);
        else poke(seg_ecran,76,Curs_C);
        }
      else
        {
        if ( (mod_scr==2) | (mod_scr==3) | (mod_scr==7) )
          poke(seg_ecran,158,Curs_F);
        else poke(seg_ecran,76,Curs_F);
        }
      }

    /* That's the end of our clock interrupt. */
    compteur = 0;
    ItClk_active = FALSE;
    }

  /* Call to the previous clock interrupt */
  asm pushf
  (*OldIClk) ();
  }


void install_Clock()
  {
  inregs.h.ah = 0x0F;
  int86(0x10,&inregs,&outregs);
  if (outregs.h.al==7) seg_ecran = 0xB000;
    else seg_ecran = 0xB800;
  OldIClk = getvect(Int1C);
  setvect(Int1C,Check_HModem_State);
  }


void un_install_Clock()
  {
  setvect(Int1C,OldIClk);
  }
